//RGB Saber Code
//Take From OJP
//Note the line numbers in the OJP Code are most likely to be different in other code
//This is just for rough guidance

CG_Local.h

Line 323:

	//[RGBSabers]
	//[2] array cause there are 2 sabers :)

	vec3_t	rgb1;
	vec3_t	rgb2;
	vec3_t	PimpColorFrom[2];
	vec3_t	PimpColorTo[2];
	int		PimpStartTime[2];
	int		PimpEndTime[2];
	vec3_t  ScriptedColors[10][2];
	int		ScriptedTimes[10][2];
	int		ScriptedNum[2]; //number of colors
	int		ScriptedActualNum[2];
	int		ScriptedStartTime[2];
	int		ScriptedEndTime[2];
	//[/RGBSabers]

	Line 1216:
	//[RGBSabers]
	qhandle_t	rgbSaberGlowShader;
	qhandle_t	rgbSaberCoreShader;
	qhandle_t	rgbSaberCore2Shader;
	qhandle_t	blackSaberGlowShader;
	qhandle_t	blackSaberTrail;
	//[/RGBSabers]

	Line 1928:
	//[RGBSabers]
	extern vmCvar_t	rgb_saber1;
	extern vmCvar_t	rgb_saber2;
	extern vmCvar_t	rgb_script1;
	extern vmCvar_t	rgb_script2;
	extern vmCvar_t ojp_teamrgbsabers;
	//[/RGBSabers]

Q_Shared.h

Line 598:

{
	SABER_RED,
	SABER_ORANGE,
	SABER_YELLOW,
	SABER_GREEN,
	SABER_BLUE,
	SABER_PURPLE,
	//[RGBSabers]
	SABER_WHITE,
	SABER_BLACK,
	SABER_RGB,
	SABER_PIMP,
	SABER_SCRIPTED,
	//[/RGBSabers]
	NUM_SABER_COLORS

};
typedef int saber_colors_t;

CG_Ents.c

Line 2813:

if ( SaberOwnInfo->saber[0].numBlades > 2 )
				{//add a single glow for the saber based on all the blade colors combined
					//[RGBSabers]
					CG_DoSaberLight( &SaberOwnInfo->saber[0], saberOwn->currentState.clientNum, 0 );
					//[/RGBSabers]
				}

CG_Main.c

Line 904:

//[RGBSabers]
vmCvar_t	rgb_saber1;
vmCvar_t	rgb_saber2;
vmCvar_t	rgb_script1;
vmCvar_t	rgb_script2;
vmCvar_t	ojp_teamrgbsabers;
//[/RGBSabers]

Line 1131:

//[RGBSabers]
	{ &rgb_saber1,	"rgb_saber1", "0,150,150", CVAR_USERINFO | CVAR_ARCHIVE },
	{ &rgb_saber2,	"rgb_saber2", "150,0,150", CVAR_USERINFO | CVAR_ARCHIVE },
	{ &rgb_script1,	"rgb_script1", ":255,0,255:500:0,0,255:500:", CVAR_USERINFO | CVAR_ARCHIVE },
	{ &rgb_script2,	"rgb_script2", ":0,255,255:500:0,255,0:500:", CVAR_USERINFO | CVAR_ARCHIVE },

	//Controls the saber blade colors during team games.
	//	0 = All sabers are based on team color
	//	1 = Player's saber is custom color, everyone else has team colors
	//	2 = Everyone has custom colors.
	{ &ojp_teamrgbsabers,	"ojp_teamrgbsabers", "0", CVAR_ARCHIVE },
//[/RGBSabers]

Line 1642:

	
	//[RGBSabers]
	cgs.media.rgbSaberGlowShader		= trap_R_RegisterShader( "gfx/effects/sabers/rgb_glow" );
	cgs.media.rgbSaberCoreShader		= trap_R_RegisterShader( "gfx/effects/sabers/rgb_line" );
	cgs.media.rgbSaberCore2Shader		= trap_R_RegisterShader( "gfx/effects/sabers/rgb_core" );
	cgs.media.blackSaberGlowShader		= trap_R_RegisterShader( "gfx/effects/sabers/black_glow" );
	cgs.media.blackSaberTrail			= trap_R_RegisterShader( "gfx/effects/sabers/blacksaberBlur" );
	//[/RGBSabers]

CG_Players.c

Line 2556:

/*
======================
CG_NewClientInfo
======================
*/
//[RGBSabers]
void ParseRGBSaber(char * str, vec3_t c);
void CG_ParseScriptedSaber(char *script, clientInfo_t *ci, int snum);
//[/RGBSabers]

Line 2571:

void CG_NewClientInfo( int clientNum, qboolean entitiesInitialized ) {
	clientInfo_t *ci;
	clientInfo_t newInfo;
	const char	*configstring;
	const char	*v;
	char		*slash;
//[RGBSabers]
	char		*yo,*yo2;
//[/RGBSabers]
	void *oldGhoul2;
	void *oldG2Weapons[MAX_SABERS];
	//[VisualWeapons]
	void *oldG2HolsteredWeapons[MAX_SABERS];
	//[/VisualWeapons]
	int i = 0;
	int k = 0;
	qboolean saberUpdate[MAX_SABERS];

	Line 2671:

	//copy team info out to menu
	if ( clientNum == cg.clientNum)	//this is me
	{
		trap_Cvar_Set("ui_team", v);
	}

//[RGBSabers]
	yo = Info_ValueForKey(configstring,"tc1");
	ParseRGBSaber(yo,newInfo.rgb1);

	yo = Info_ValueForKey(configstring,"tc2");
	ParseRGBSaber(yo,newInfo.rgb2);

	yo = Info_ValueForKey(configstring,"ss1");
//	Com_Printf("saber1 : %s\n",yo);
	if(yo[0] != ':')
	{
		CG_ParseScriptedSaber(":255,0,255:500:0,0,255:500",&newInfo,0);
	}
	else
		CG_ParseScriptedSaber(yo,&newInfo,0);

	yo2 = Info_ValueForKey(configstring,"ss2");
//	Com_Printf("saber1 : %s\n",yo2);
	if(yo2[0] != ':')
	{
		CG_ParseScriptedSaber(":0,255,255:500:0,0,255:500",&newInfo,1);
	}
	else
		CG_ParseScriptedSaber(yo2,&newInfo,1);
//[/RGBSabers]

	// team task
	v = Info_ValueForKey( configstring, "tt" );
	newInfo.teamTask = atoi(v);

	Line 6457:

	//[RGBSabers]
void RGB_LerpColor(vec3_t from, vec3_t to, float frac, vec3_t out)
{
	vec3_t diff;
	int i;

	VectorSubtract(to,from,diff);

	VectorCopy(from,out);

	for(i=0;i<3;i++)
		out[i] += diff[i] * frac;

}

int getint(char **buf)
{
	double temp;
	temp = strtod(*buf,buf);
	return (int)temp;
}

void ParseRGBSaber(char * str, vec3_t c)
{
	char *p = str;
	int i;

	for(i=0;i<3;i++)
	{
		c[i] = getint(&p);
		p++;
	}
}

void CG_ParseScriptedSaber(char *script, clientInfo_t *ci, int snum)
{
	int n =0,l;
	char *p = script;

	l = strlen(p);
	p++; //skip the 1st ':'

	while(p[0] && n<l)
	{
		ParseRGBSaber(p,ci->ScriptedColors[n][snum]);
		while(p[0]!=':')
			p++;
		p++;            //skipped 1st point 

		ci->ScriptedTimes[n][snum] = getint(&p);
		
		p++;
		n++;
	}
	ci->ScriptedNum[snum] = n;
}

void RGB_AdjustSciptedSaberColor(clientInfo_t *ci, vec3_t color, int n)
{
	int actual;
	float frac;

	if(!ci->ScriptedStartTime[n])
	{
		ci->ScriptedActualNum[n] = 0;
		ci->ScriptedStartTime[n] = cg.time;
		ci->ScriptedEndTime[n] = cg.time + ci->ScriptedTimes[0][n];
	}
	else if(ci->ScriptedEndTime[n] < cg.time)
	{
		ci->ScriptedActualNum[n] = (ci->ScriptedActualNum[n] + 1) % ci->ScriptedNum[n];
		actual = ci->ScriptedActualNum[n];
		ci->ScriptedStartTime[n] = cg.time;
		ci->ScriptedEndTime[n] = cg.time + ci->ScriptedTimes[actual][n];
	}

	actual = ci->ScriptedActualNum[n];

	frac = (float)(cg.time - ci->ScriptedStartTime[n]) / (float)(ci->ScriptedEndTime[n] - ci->ScriptedStartTime[n]);


	if(actual+1 != ci->ScriptedNum[n])
		RGB_LerpColor(ci->ScriptedColors[actual][n], ci->ScriptedColors[actual+1][n], frac, color);
	else
		RGB_LerpColor(ci->ScriptedColors[actual][n], ci->ScriptedColors[0][n], frac, color);

}



#define PIMP_MIN_INTESITY 120

void RGB_RandomRGB(vec3_t c)
{
	int i;
	for(i=0;i<3;i++)
		c[i]=0;

	while(c[0]+c[1]+c[2] < PIMP_MIN_INTESITY)
		for(i=0;i<3;i++)
			c[i] = rand() % 255;

}

void RGB_AdjustPimpSaberColor(clientInfo_t *ci, vec3_t color, int n)
{
	int time;
	float frac;

	if(!ci->PimpStartTime[n])
	{
		ci->PimpStartTime[n] = cg.time;
		RGB_RandomRGB(ci->PimpColorFrom[n]);
		RGB_RandomRGB(ci->PimpColorTo[n]);
		time = 250 + rand()%250;
//		time = 500 + rand()%250;
		ci->PimpEndTime[n] = cg.time + time;
	}
	else if(ci->PimpEndTime[n] < cg.time)
	{
		VectorCopy(ci->PimpColorTo[n], ci->PimpColorFrom[n]);
		RGB_RandomRGB(ci->PimpColorTo[n]);
		time = 250 + rand()%250;
		ci->PimpStartTime[n] = cg.time;
		ci->PimpEndTime[n] = cg.time + time;
	}

	frac = (float)(cg.time - ci->PimpStartTime[n]) / (float)(ci->PimpEndTime[n] - ci->PimpStartTime[n]);

//	Com_Printf("frac : %f\n",frac);

	RGB_LerpColor(ci->PimpColorFrom[n], ci->PimpColorTo[n], frac, color);

}


static void CG_RGBForSaberColor( saber_colors_t color, vec3_t rgb, int cnum, int bnum )
//[/RGBSabers]
{
	switch( color )
	{
		case SABER_RED:
			VectorSet( rgb, 1.0f, 0.2f, 0.2f );
			break;
		case SABER_ORANGE:
			VectorSet( rgb, 1.0f, 0.5f, 0.1f );
			break;
		case SABER_YELLOW:
			VectorSet( rgb, 1.0f, 1.0f, 0.2f );
			break;
		case SABER_GREEN:
			VectorSet( rgb, 0.2f, 1.0f, 0.2f );
			break;
		case SABER_BLUE:
			VectorSet( rgb, 0.2f, 0.4f, 1.0f );
			break;
		case SABER_PURPLE:
			VectorSet( rgb, 0.9f, 0.2f, 1.0f );
			break;
//[RGBSabers]
		case SABER_RGB:
			{
				if(cnum < MAX_CLIENTS)
				{
					int i;
					clientInfo_t *ci = &cgs.clientinfo[cnum];

					if(bnum == 0)
						VectorCopy(ci->rgb1, rgb);
					else
						VectorCopy(ci->rgb2, rgb);
					for(i=0;i<3;i++)
						rgb[i]/=255;
				}
				else
					VectorSet( rgb, 0.2f, 0.4f, 1.0f );
			}
			break;
		case SABER_PIMP:
			{
				if(cnum < MAX_CLIENTS)
				{
					int i;
					clientInfo_t *ci = &cgs.clientinfo[cnum];

					RGB_AdjustPimpSaberColor(ci, rgb,bnum);

					for(i=0;i<3;i++)
						rgb[i]/=255;
				}
				else
					VectorSet( rgb, 0.2f, 0.4f, 1.0f );
			}
			break;
		case SABER_SCRIPTED:
			{
				if(cnum < MAX_CLIENTS)
				{
					int i;
					clientInfo_t *ci = &cgs.clientinfo[cnum];

					RGB_AdjustSciptedSaberColor(ci, rgb,bnum);

					for(i=0;i<3;i++)
						rgb[i]/=255;
				}
				else
					VectorSet( rgb, 0.2f, 0.4f, 1.0f );
			}

			break;
		case SABER_BLACK:
			VectorSet( rgb, 0.0f, 0.0f, 0.0f );
			break;
		case SABER_WHITE:
			VectorSet( rgb, 1.0f, 1.0f, 1.0f );
			break;
	}
//	Com_Printf("sabercolor %i %i %i ^1%i %i\n",(int)rgb[0],(int)rgb[1],(int)rgb[2],cnum,bnum);
}

//[SaberThrowSys]
//changed this from static so we can use it for rendering the saber blade for 
//dropped/ballastics sabers.
void CG_DoSaberLight( saberInfo_t *saber , int cnum, int bnum)
//static void CG_DoSaberLight( saberInfo_t *saber , int cnum, int bnum)
//[/SaberThrowSys]
//[/RGBSabers]

Line 6706:

//FIXME: make RGB sabers
			//[RGBSabers]
			CG_RGBForSaberColor( saber->blade[i].color, rgbs[i] , cnum, bnum);
			//[/RGBSabers]

			Line 6768:

			//[RGBSabers]
		trap_R_AddLightToScene( mid, (diameter + random()*8.0f), rgb[0], rgb[1], rgb[2] );
	}

	Line 6821:

	//[RGBSabers]
		case SABER_SCRIPTED:
		case SABER_WHITE:
		case SABER_PIMP:
		case SABER_RGB:
			glow = cgs.media.rgbSaberGlowShader;
			blade = cgs.media.rgbSaberCoreShader;
			break;
		case SABER_BLACK:
			glow = cgs.media.blackSaberGlowShader;
			blade = cgs.media.rgbSaberCoreShader;
			break;
		//[/RGBSabers]

			Line 6842:

			if (doLight)
	{	// always add a light because sabers cast a nice glow before they slice you in half!!  or something...
		//[RGBSabers]
		float light = length*1.4f + random()*3.0f;
		CG_RGBForSaberColor( color, rgb , cnum, bnum);
		trap_R_AddLightToScene( mid, light, rgb[0], rgb[1], rgb[2] );
		//[/RGBSabers]
	}

			Line 6871:

	{ //draw the blade as a post-render so it doesn't get in the cap...
		rfx |= RF_FORCEPOST;
	}

	//[RGBSabers]
	for(i=0;i<3;i++)
		rgb[i] *= 255;
	//[/RGBSabers]

	Line 6885:

	//[RGBSabers]
	if(color != SABER_RGB && color != SABER_PIMP && color != SABER_WHITE && color != SABER_SCRIPTED)
		saber.shaderRGBA[0] = saber.shaderRGBA[1] = saber.shaderRGBA[2] = saber.shaderRGBA[3] = 0xff;
	else
	{
		for(i=0;i<3;i++)
			saber.shaderRGBA[i] = rgb[i];
		saber.shaderRGBA[3] = 255;
	}
	//[/RGBSabers]

	Line 6193:

	//[RGBSabers]
	if(color != SABER_RGB && color != SABER_PIMP && color != SABER_WHITE && color != SABER_SCRIPTED)
		saber.shaderRGBA[0] = saber.shaderRGBA[1] = saber.shaderRGBA[2] = saber.shaderRGBA[3] = 0xff;
	else
	{
		for(i=0;i<3;i++)
			saber.shaderRGBA[i] = rgb[i];
		saber.shaderRGBA[3] = 255;
	}

	sbak = saber;
	trap_R_AddRefEntityToScene( &saber );

	if(color != SABER_RGB && color != SABER_PIMP && color != SABER_WHITE && color != SABER_SCRIPTED)
		return;

	sbak.customShader = cgs.media.rgbSaberCore2Shader;
	saber.reType = RT_LINE;
	saber.shaderTexCoord[0] = saber.shaderTexCoord[1] = 1.0f;
	saber.shaderRGBA[0] = saber.shaderRGBA[1] = saber.shaderRGBA[2] = saber.shaderRGBA[3] = 0xff;
	saber.radius = (radiusStart + crandom() * radiusRange)*radiusmult;
	trap_R_AddRefEntityToScene( &sbak );
	//[/RGBSabers]

}//END OF A FUNCTION DOSaber()

Line 7407:

//[RGBSabers]
									CG_AddGhoul2Mark(markShader, flrand(3.0f, 4.0f),
										trace.endpos, ePos, trace.entityNum, trEnt->lerpOrigin, trEnt->lerpAngles[YAW],
										trEnt->ghoul2, trEnt->modelScale, Q_irand(5000, 10000));
									if ( weaponMarkShader )
									{
										vec3_t splashBackDir;
										VectorScale( ePos, -1 , splashBackDir );
										CG_AddGhoul2Mark(weaponMarkShader, flrand(0.5f, 2.0f),
											trace.endpos, splashBackDir, owner->currentState.clientNum, owner->lerpOrigin, owner->lerpAngles[YAW],
											owner->ghoul2, owner->modelScale, Q_irand(5000, 10000));
									}
									//[/RGBSabers]
Line 7879:

									//[RGBSabers]
						case SABER_RGB:
							{
								int cnum = cent->currentState.clientNum;
								if(cnum < MAX_CLIENTS)
								{
									clientInfo_t *ci = &cgs.clientinfo[cnum];

									if(saberNum == 0)
										VectorCopy(ci->rgb1, rgb1);
									else
										VectorCopy(ci->rgb2, rgb1);
								}
								else
								VectorSet( rgb1, 0.0f, 64.0f, 255.0f );
							}
							break;
						case SABER_PIMP:
							{
								int cnum = cent->currentState.clientNum;
								if(cnum < MAX_CLIENTS)
								{
									clientInfo_t *ci = &cgs.clientinfo[cnum];
									RGB_AdjustPimpSaberColor(ci,rgb1,saberNum);

								}
								else
								VectorSet( rgb1, 0.0f, 64.0f, 255.0f );

							}
							break;
						case SABER_SCRIPTED:
							{
								int cnum = cent->currentState.clientNum;
								if(cnum < MAX_CLIENTS)
								{
									clientInfo_t *ci = &cgs.clientinfo[cnum];
									RGB_AdjustSciptedSaberColor(ci,rgb1,saberNum);

								}
								else
								VectorSet( rgb1, 0.0f, 64.0f, 255.0f );

							}
							break;
						case SABER_BLACK:
							VectorSet( rgb1, 1.0f, 1.0f, 1.0f );
							break;
						case SABER_WHITE:
							VectorSet( rgb1, 1.0f, 1.0f, 1.0f );
							break;
						//[/RGBSabers]
Line 8037:


//[RGBSabers]
if(scolor == SABER_BLACK)
fx.mShader = cgs.media.blackSaberTrail;
//[/RGBSabers]

Line 8066:

{//hmm, but still add the dlight
			//[RGBSabers]
			CG_DoSaberLight( &client->saber[saberNum] ,cent->currentState.clientNum, saberNum);
			//[/RGBSabers]
		}
		return;

Line 8077:

// Pass in the renderfx flags attached to the saber weapon model...this is done so that saber glows
	//	will get rendered properly in a mirror...not sure if this is necessary??
	//CG_DoSaber( org_, axis_[0], saberLen, client->saber[saberNum].blade[bladeNum].lengthMax, client->saber[saberNum].blade[bladeNum].radius,
	//	scolor, renderfx, (qboolean)(saberNum==0&&bladeNum==0) );
	CG_DoSaber( org_, axis_[0], saberLen, client->saber[saberNum].blade[bladeNum].lengthMax, client->saber[saberNum].blade[bladeNum].radius,
		//[RGBSabers]
		scolor, renderfx, (qboolean)(client->saber[saberNum].numBlades < 3 && !(client->saber[saberNum].saberFlags2&SFL2_NO_DLIGHT)),
		cent->currentState.clientNum, saberNum);
		//[/RGBSabers]
}

Line 13574:

if ( ci->saber[l].numBlades > 2 )
						{//add a single glow for the saber based on all the blade colors combined
							//[RGBSabers]
							CG_DoSaberLight( &ci->saber[l], cent->currentState.clientNum, l );
							//[/RGBSabers]
						}

						l++;

Line 13885:

if ( ci->saber[l].numBlades > 2 )
			{//add a single glow for the saber based on all the blade colors combined
				//[RGBSabers]
				CG_DoSaberLight( &ci->saber[l], cent->currentState.clientNum, l );
				//[/RGBSabers]
			}

			l++;

UI_local.h

Line 90:

//[RGBSabers]
extern vmCvar_t	ui_sab1_r;
extern vmCvar_t	ui_sab1_g;
extern vmCvar_t	ui_sab1_b;
extern vmCvar_t	ui_sab2_r;
extern vmCvar_t	ui_sab2_g;
extern vmCvar_t	ui_sab2_b;
//[/RGBSabers]

//
// ui_qmenu.c
//

UI_main.c

Line 6082:

static void UI_UpdateSaberColor( qboolean secondSaber )
{
	//[RGBSabers]
	char str[32];
	str[0] = '\0';

	strncat(str,va("%i,%i,%i",ui_sab1_r.integer,ui_sab1_g.integer,ui_sab1_b.integer),sizeof(str));
	trap_Cvar_Set("rgb_saber1", str);
	str[0] = '\0';

	strncat(str,va("%i,%i,%i",ui_sab2_r.integer,ui_sab2_g.integer,ui_sab2_b.integer),sizeof(str));
	trap_Cvar_Set("rgb_saber2", str);

//	Com_Printf("update saber : %i\n",secondSaber);
	//[/RGBSabers]
}

Line 6099:

extern char * SaberColorToString(saber_colors_t color);

//[RGBSabers]
void ParseRGBSaber(char * str, vec3_t c);
void UI_ParseScriptedSaber(char *script, int snum);
//[/RGBSabers]
static void UI_GetSaberCvars ( void )
{
//[RGBSabers]
	char strgb1[64],strgb2[64];
	char scr1[256],scr2[256];
	vec3_t c1,c2;
//[/RGBSabers]

	Line 6121:

	//[RGBSabers]
	strncpy(strgb1, UI_Cvar_VariableString("rgb_saber1"),sizeof(strgb1));
	strncpy(strgb2, UI_Cvar_VariableString("rgb_saber2"),sizeof(strgb2));

	ParseRGBSaber(strgb1,c1);
	ParseRGBSaber(strgb2,c2);

	trap_Cvar_Set("ui_sab1_r", va("%f",c1[0]));
	trap_Cvar_Set("ui_sab1_g", va("%f",c1[1]));
	trap_Cvar_Set("ui_sab1_b", va("%f",c1[2]));

	trap_Cvar_Set("ui_sab2_r", va("%f",c2[0]));
	trap_Cvar_Set("ui_sab2_g", va("%f",c2[1]));
	trap_Cvar_Set("ui_sab2_b", va("%f",c2[2]));

	/*
	fs(set,"%f",c1[0]);
	trap_Cvar_Set("ui_sab1_r",set);
	fs(set,"%f",c1[1]);
	trap_Cvar_Set("ui_sab1_g",set);
	fs(set,"%f",c1[2]);
	trap_Cvar_Set("ui_sab1_b",set);

	fs(set,"%f",c2[0]);
	trap_Cvar_Set("ui_sab2_r",set);
	fs(set,"%f",c2[1]);
	trap_Cvar_Set("ui_sab2_g",set);
	fs(set,"%f",c2[2]);
	trap_Cvar_Set("ui_sab2_b",set);
	*/

	strncpy(scr1, UI_Cvar_VariableString("rgb_script1"),sizeof(scr1));
	strncpy(scr2, UI_Cvar_VariableString("rgb_script2"),sizeof(scr2));

	if(scr1[0] != ':')
	{
		trap_Cvar_Set("rgb_script1",":255,0,255:500:0,0,255:500:");
		strncpy(scr1,":255,0,255:500:0,0,255:500:\0",sizeof(scr1));
	}
	if(scr2[0] != ':')
	{
		trap_Cvar_Set("rgb_script2",":0,255,255:500:0,0,255:500:");
		strncpy(scr2,":0,255,255:500:0,0,255:500:\0",sizeof(scr2));
	}

	UI_ParseScriptedSaber(scr1,0);
	UI_ParseScriptedSaber(scr2,1);

//	Com_Printf("ui_getsabercvar > %i,%i,%i %i,%i,%i\n",ui_sab1_r.integer,ui_sab1_g.integer,ui_sab1_b.integer,ui_sab2_r.integer,ui_sab2_g.integer,ui_sab2_b.integer);
//[/RGBSabers]

	Line 11614:

	//[RGBSabers]
vmCvar_t	ui_sab1_r;
vmCvar_t	ui_sab1_g;
vmCvar_t	ui_sab1_b;
vmCvar_t	ui_sab2_r;
vmCvar_t	ui_sab2_g;
vmCvar_t	ui_sab2_b;
//[/RGBSabers]

Line 11759:

//END JLFCALLOUT
//[RGBSabers]
	{ &ui_sab1_r,			"ui_sab1_r", "255", CVAR_INTERNAL},
	{ &ui_sab1_g,			"ui_sab1_g", "255", CVAR_INTERNAL},
	{ &ui_sab1_b,			"ui_sab1_b", "255", CVAR_INTERNAL},
	{ &ui_sab2_r,			"ui_sab2_r", "255", CVAR_INTERNAL},
	{ &ui_sab2_g,			"ui_sab2_g", "255", CVAR_INTERNAL},
	{ &ui_sab2_b,			"ui_sab2_b", "255", CVAR_INTERNAL},
//[/RGBSabers]
};

UI_Saber.c

Line 38:

static qhandle_t purpleSaberGlowShader;
static qhandle_t purpleSaberCoreShader;

//[RGBSabers]
static qhandle_t rgbSaberCoreShader;
static qhandle_t rgbSaberGlowShader;
static qhandle_t rgbSaberCore2Shader;
static qhandle_t blackSaberGlowShader;
//[/RGBSabers]

Line 59:

purpleSaberGlowShader		= trap_R_RegisterShaderNoMip( "gfx/effects/sabers/purple_glow" );
	purpleSaberCoreShader		= trap_R_RegisterShaderNoMip( "gfx/effects/sabers/purple_line" );
	//[RGBSabers]
	rgbSaberGlowShader		= trap_R_RegisterShaderNoMip( "gfx/effects/sabers/rgb_glow" );
	rgbSaberCoreShader		= trap_R_RegisterShaderNoMip( "gfx/effects/sabers/rgb_line" );
	rgbSaberCore2Shader		= trap_R_RegisterShaderNoMip( "gfx/effects/sabers/rgb_core" );
	blackSaberGlowShader		= trap_R_RegisterShaderNoMip( "gfx/effects/sabers/black_glow" );
	//[/RGBSabers]

}

Line 416:

//[RGBSabers]
void RGB_LerpColor(vec3_t from, vec3_t to, float frac, vec3_t out)
{
	vec3_t diff;
	int i;

	VectorSubtract(to,from,diff);

	VectorCopy(from,out);

	for(i=0;i<3;i++)
		out[i] += diff[i] * frac;

}

int getint(char **buf)
{
	double temp;
	temp = strtod(*buf,buf);
	return (int)temp;
}

void ParseRGBSaber(char * str, vec3_t c)
{
	char *p = str;
	int i;

	for(i=0;i<3;i++)
	{
		c[i] = getint(&p);
		p++;
	}
}

vec3_t  ScriptedColors[10][2]	= {0};
int		ScriptedTimes[10][2]	= {0};
int		ScriptedNum[2]			= {0}; //number of colors
int		ScriptedActualNum[2]	= {0};
int		ScriptedStartTime[2]	= {0};
int		ScriptedEndTime[2]		= {0};

void UI_ParseScriptedSaber(char *script, int snum)
{
	int n =0,l;
	char *p = script;
//	vec3_t yop;

	l = strlen(p);
	p++; //skip the 1st ':'

//	Com_Printf("saber[%i] > %s\n",snum,p);
	while(p[0] && n < l)
	{
		ParseRGBSaber(p,ScriptedColors[n][snum]);
		while(p[0]!=':')
			p++;
		p++;            //skipped ':' 

		ScriptedTimes[n][snum] = getint(&p);

//		VectorCopy(ScriptedColors[n][snum],yop);
//		Com_Printf("saber[%i] > %i %i %i > %i\n",snum,(int)yop[0],(int)yop[1],(int)yop[2],ScriptedTimes[n][snum]);

		p++;
		n++;
	}
	ScriptedNum[snum] = n;
}


void RGB_AdjustSciptedSaberColor(vec3_t color, int n)
{
	int actual;
	float frac;
	int time = uiInfo.uiDC.realTime,i;

//	Com_Printf("%i\n",time);

	if(!ScriptedStartTime[n])
	{
//		Com_Printf("startnewColor\n");
		ScriptedActualNum[n] = 0;
		ScriptedStartTime[n] = time;
		ScriptedEndTime[n] = time + ScriptedTimes[0][n];
	}
	else if(ScriptedEndTime[n] < time)
	{
		ScriptedActualNum[n] = (ScriptedActualNum[n] + 1) % ScriptedNum[n];
		actual = ScriptedActualNum[n];
		ScriptedStartTime[n] = time;
		ScriptedEndTime[n] = time + ScriptedTimes[actual][n];
	}

	actual = ScriptedActualNum[n];

	frac = (float)(time - ScriptedStartTime[n]) / (float)(ScriptedEndTime[n] - ScriptedStartTime[n]);


	if(actual+1 != ScriptedNum[n])
		RGB_LerpColor(ScriptedColors[actual][n], ScriptedColors[actual+1][n], frac, color);
	else
		RGB_LerpColor(ScriptedColors[actual][n], ScriptedColors[0][n], frac, color);

	for(i=0;i<3;i++)
		color[i]/=255;
//	Com_Printf("%i %i %i\n",(int)color[0],(int)color[1],(int)color[2]);

}

#define PIMP_MIN_INTESITY 120

void RGB_RandomRGB(vec3_t c)
{
	int i;
	for(i=0;i<3;i++)
		c[i]=0;

	while(c[0]+c[1]+c[2] < PIMP_MIN_INTESITY)
		for(i=0;i<3;i++)
			c[i] = rand() % 255;

//	Com_Printf("color : %i %i %i\n",(int)c[0],(int)c[1],(int)c[2]);
}

int PimpStartTime[2];
int PimpEndTime[2];
vec3_t PimpColorFrom[2];
vec3_t PimpColorTo[2];

void RGB_AdjustPimpSaberColor(vec3_t color, int n)
{
	int time,i;
	float frac;

	if(!PimpStartTime[n])
	{
		PimpStartTime[n] = uiInfo.uiDC.realTime;
		RGB_RandomRGB(PimpColorFrom[n]);
		RGB_RandomRGB(PimpColorTo[n]);
		time = 250 + rand()%250;
		PimpEndTime[n] = uiInfo.uiDC.realTime + time;
	}
	else if(PimpEndTime[n] < uiInfo.uiDC.realTime)
	{
		VectorCopy(PimpColorTo[n], PimpColorFrom[n]);
		RGB_RandomRGB(PimpColorTo[n]);
		time = 250 + rand()%250;
		PimpStartTime[n] = uiInfo.uiDC.realTime;
		PimpEndTime[n] = uiInfo.uiDC.realTime + time;
	}

	frac = (float)(uiInfo.uiDC.realTime - PimpStartTime[n]) / (float)(PimpEndTime[n] - PimpStartTime[n]);

	RGB_LerpColor(PimpColorFrom[n], PimpColorTo[n], frac, color);

	for(i=0;i<3;i++)
		color[i]/=255;

}

void UI_DoSaber( vec3_t origin, vec3_t dir, float length, float lengthMax, float radius, saber_colors_t color, int snum )
//[/RGBSabers]

Line 586:

//[RGBSabers]
	int i;
//[/RGBSabers]

	Line 631:

	//[RGBSabers]
		case SABER_RGB:
			{
				if(snum == 0)
					VectorSet( rgb, ui_sab1_r.value, ui_sab1_g.value, ui_sab1_b.value );
				else
					VectorSet( rgb, ui_sab2_r.value, ui_sab2_g.value, ui_sab2_b.value );

				for(i=0;i<3;i++)
					rgb[i]/=255;

				glow = rgbSaberGlowShader;
				blade = rgbSaberCoreShader;
			}
			break;
		case SABER_PIMP:
			glow = rgbSaberGlowShader;
			blade = rgbSaberCoreShader;
			RGB_AdjustPimpSaberColor(rgb,snum);
			break;
		case SABER_WHITE:
			glow = rgbSaberGlowShader;
			blade = rgbSaberCoreShader;
			VectorSet( rgb, 1.0f, 1.0f, 1.0f );
			break;
		case SABER_BLACK:
			glow = blackSaberGlowShader;
			blade = rgbSaberCoreShader;
			VectorSet( rgb, .0f, .0f, .0f );
			break;
		case SABER_SCRIPTED:
			glow = rgbSaberGlowShader;
			blade = rgbSaberCoreShader;
			RGB_AdjustSciptedSaberColor(rgb,snum);
			break;
//[/RGBSabers]

	}

Line 706:

		saber.customShader = glow;
//[RGBSabers]
	if(color != SABER_RGB && color != SABER_PIMP && color != SABER_WHITE && color != SABER_SCRIPTED)
		saber.shaderRGBA[0] = saber.shaderRGBA[1] = saber.shaderRGBA[2] = saber.shaderRGBA[3] = 0xff;
	else
	{
		int i;
		for(i=0;i<3;i++)
			saber.shaderRGBA[i] = rgb[i]*255;
		saber.shaderRGBA[3] = 255;
	}
//[/RGBSabers]
	//saber.renderfx = rfx;

	Line 732:

	
	trap_R_AddRefEntityToScene( &saber );

	//[RGBSabers]
	if(color != SABER_RGB && color != SABER_PIMP && color != SABER_WHITE && color != SABER_SCRIPTED)
		return;

	saber.customShader = rgbSaberCore2Shader;
	saber.reType = RT_LINE;
	saber.shaderTexCoord[0] = saber.shaderTexCoord[1] = 1.0f;
	saber.shaderRGBA[0] = saber.shaderRGBA[1] = saber.shaderRGBA[2] = saber.shaderRGBA[3] = 0xff;
	saber.radius = (radiusStart + crandom() * radiusRange)*radiusmult;
	trap_R_AddRefEntityToScene( &saber );
	//[/RGBSabers]

}

Line 766:

//[RGBSabers]
	if ( color == SABER_WHITE)
		return "white";

	if ( color == SABER_BLACK)
		return "black";

	if ( color == SABER_RGB)
		return "rgb";

	if ( color == SABER_PIMP)
		return "pimp";

	if ( color == SABER_SCRIPTED)
		return "scripted";
	//[/RGBSabers]


	Line 812:

	//[RGBSabers]
	if ( !Q_stricmp( name, "rgb" ) ) 
	{
		return SABER_RGB;
	}
	if ( !Q_stricmp( name, "pimp" ) ) 
	{
		return SABER_PIMP;
	}
	if ( !Q_stricmp( name, "white" ) ) 
	{
		return SABER_WHITE;
	}
	if ( !Q_stricmp( name, "black" ) ) 
	{
		return SABER_BLACK;
	}
	if ( !Q_stricmp( name, "scripted" ) ) 
	{
		return SABER_SCRIPTED;
	}
	//[/RGBSabers]

	Line 908:

	mdxaBone_t	boltMatrix;
	qboolean tagHack = qfalse;
	char *tagName;
	int bolt;
	float scale;
	//[RGBSabers]
	int snum;
	//[/RGBSabers]

	Line 914:

	
	if ( (item->flags&ITF_ISSABER) && saberModel < 2 )
	{
		//[RGBSabers]
		snum = 0;
		trap_Cvar_VariableStringBuffer("ui_saber_color", bladeColorString, sizeof(bladeColorString) );
	}
	else//if ( item->flags&ITF_ISSABER2 ) - presumed
	{
		snum = 1;
		//[/RGBSabers]
		trap_Cvar_VariableStringBuffer("ui_saber2_color", bladeColorString, sizeof(bladeColorString) );
	}

	Line 1131:

	//[RGBSabers]
	UI_DoSaber( bladeOrigin, axis[0], bladeLength, bladeLength, bladeRadius, bladeColor, snum );
//[/RGBSabers]

G_bot.c

Line 1546:

//[RGBSabers]
	key = "rgb_saber1";
	s = Info_ValueForKey( botinfo, key );
	if ( !*s ) {
		s = "255,0,0";
	}
	Info_SetValueForKey( userinfo, key, s );

	key = "rgb_saber2";
	s = Info_ValueForKey( botinfo, key );
	if ( !*s ) {
		s = "0,255,255";
	}
	Info_SetValueForKey( userinfo, key, s );

	key = "rgb_script1";
	s = Info_ValueForKey( botinfo, key );
	if ( !*s ) {
		s = "none";
	}
	Info_SetValueForKey( userinfo, key, s );

	key = "rgb_script2";
	s = Info_ValueForKey( botinfo, key );
	if ( !*s ) {
		s = "none";
	}
	Info_SetValueForKey( userinfo, key, s );
	//[/RGBSabers]

G_Client.c

Line 1990:

char	*value;
	int		maxHealth;

	//[RGBSabers]
	char	rgb1[MAX_INFO_STRING];
	char	rgb2[MAX_INFO_STRING];
	char	script1[MAX_INFO_STRING];
	char	script2[MAX_INFO_STRING];
	//[/RGBSabers]

	qboolean	modelChanged = qfalse;

Line 2317:

	//[RGBSabers]
	Q_strncpyz(rgb1,Info_ValueForKey(userinfo, "rgb_saber1"), sizeof(rgb1));
	Q_strncpyz(rgb2,Info_ValueForKey(userinfo, "rgb_saber2"), sizeof(rgb2));

	Q_strncpyz(script1,Info_ValueForKey(userinfo, "rgb_script1"), sizeof(script1));
	Q_strncpyz(script2,Info_ValueForKey(userinfo, "rgb_script2"), sizeof(script2));


//	Com_Printf("game > newinfo update > sab1 \"%s\" sab2 \"%s\" \n",rgb1,rgb2);

	// send over a subset of the userinfo keys so other clients can
	// print scoreboards, display models, and play custom sounds
	//[RGBSabers]
	if ( ent->r.svFlags & SVF_BOT ) {
		s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\skill\\%s\\tt\\%d\\tl\\%d\\siegeclass\\%s\\st\\%s\\st2\\%s\\dt\\%i\\sdt\\%i\\tc1\\%s\\tc2\\%s\\ss1\\%s\\ss2\\%s",
			client->pers.netname, team, model,  c1, c2, 
			client->pers.maxHealth, client->sess.wins, client->sess.losses,
			Info_ValueForKey( userinfo, "skill" ), teamTask, teamLeader, className, saberName, saber2Name, client->sess.duelTeam, client->sess.siegeDesiredTeam,
			rgb1,rgb2,script1,script2);
	} else {
		if (g_gametype.integer == GT_SIEGE)
		{ //more crap to send
			s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\tt\\%d\\tl\\%d\\siegeclass\\%s\\st\\%s\\st2\\%s\\dt\\%i\\sdt\\%i\\tc1\\%s\\tc2\\%s\\ss1\\%s\\ss2\\%s",
				client->pers.netname, client->sess.sessionTeam, model, c1, c2, 
				client->pers.maxHealth, client->sess.wins, client->sess.losses, teamTask, teamLeader, className, saberName, saber2Name, client->sess.duelTeam, client->sess.siegeDesiredTeam,rgb1,rgb2,script1,script2);
		}
		else
		{
			s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\tt\\%d\\tl\\%d\\st\\%s\\st2\\%s\\dt\\%i\\tc1\\%s\\tc2\\%s\\ss1\\%s\\ss2\\%s",
				client->pers.netname, client->sess.sessionTeam, model, c1, c2, 
				client->pers.maxHealth, client->sess.wins, client->sess.losses, teamTask, teamLeader, saberName, saber2Name, client->sess.duelTeam,rgb1,rgb2,script1,script2);
	//[/RGBSabers]
		}
	}

	Line 2329:

	//[RGBSabers]
	if ( ent->r.svFlags & SVF_BOT ) {
		s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\skill\\%s\\tt\\%d\\tl\\%d\\siegeclass\\%s\\st\\%s\\st2\\%s\\dt\\%i\\sdt\\%i\\tc1\\%s\\tc2\\%s\\ss1\\%s\\ss2\\%s",
			client->pers.netname, team, model,  c1, c2, 
			client->pers.maxHealth, client->sess.wins, client->sess.losses,
			Info_ValueForKey( userinfo, "skill" ), teamTask, teamLeader, className, saberName, saber2Name, client->sess.duelTeam, client->sess.siegeDesiredTeam,
			rgb1,rgb2,script1,script2);
	} else {
		if (g_gametype.integer == GT_SIEGE)
		{ //more crap to send
			s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\tt\\%d\\tl\\%d\\siegeclass\\%s\\st\\%s\\st2\\%s\\dt\\%i\\sdt\\%i\\tc1\\%s\\tc2\\%s\\ss1\\%s\\ss2\\%s",
				client->pers.netname, client->sess.sessionTeam, model, c1, c2, 
				client->pers.maxHealth, client->sess.wins, client->sess.losses, teamTask, teamLeader, className, saberName, saber2Name, client->sess.duelTeam, client->sess.siegeDesiredTeam,rgb1,rgb2,script1,script2);
		}
		else
		{
			s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\tt\\%d\\tl\\%d\\st\\%s\\st2\\%s\\dt\\%i\\tc1\\%s\\tc2\\%s\\ss1\\%s\\ss2\\%s",
				client->pers.netname, client->sess.sessionTeam, model, c1, c2, 
				client->pers.maxHealth, client->sess.wins, client->sess.losses, teamTask, teamLeader, saberName, saber2Name, client->sess.duelTeam,rgb1,rgb2,script1,script2);
	//[/RGBSabers]
		}
	}







